// Sample data initialization for Direct'sell marketplace

// Initialize sample data if localStorage is empty
function initializeSampleData() {
    // Check if we already have data
    if (localStorage.getItem('users') && JSON.parse(localStorage.getItem('users')).length > 0) {
        return; // Don't initialize if we already have data
    }

    // Create sample users
    const sampleUsers = [
        {
            id: 'user1',
            shopName: 'Tech Gadgets Store',
            name: 'John Doe',
            email: 'john@example.com',
            phone: '+91 9876543210',
            password: 'password123',
            postedProducts: ['prod1', 'prod3'],
            soldProducts: ['prod5'],
            contact: '+91 9876543210',
            location: 'Mumbai',
            createdAt: new Date().toISOString()
        },
        {
            id: 'user2',
            shopName: 'Fitness World',
            name: 'Jane Smith',
            email: 'jane@example.com',
            phone: '+91 9876543211',
            password: 'password123',
            postedProducts: ['prod2', 'prod4'],
            soldProducts: [],
            contact: '+91 9876543211',
            location: 'Delhi',
            createdAt: new Date().toISOString()
        },
        {
            id: 'user3',
            shopName: 'Fashion Boutique',
            name: 'Bob Johnson',
            email: 'bob@example.com',
            phone: '+91 9876543212',
            password: 'password123',
            postedProducts: [],
            soldProducts: ['prod6'],
            contact: '+91 9876543212',
            location: 'Bangalore',
            createdAt: new Date().toISOString()
        }
    ];

    // Create sample products
    const sampleProducts = [
        {
            id: 'prod1',
            title: 'Brand New iPhone 13',
            price: 45000,
            category: 'electronics',
            condition: 'new',
            location: 'Mumbai',
            description: 'Unboxed iPhone 13 with original box and accessories. Purchased 2 months ago.',
            images: ['assets/images/placeholder.jpg'],
            sellerId: 'user1',
            sellerName: 'John Doe',
            isSold: false,
            datePosted: new Date(Date.now() - 2 * 24 * 60 * 60 * 1000).toISOString() // 2 days ago
        },
        {
            id: 'prod2',
            title: 'Gym Equipment Set',
            price: 15000,
            category: 'others',
            condition: 'used',
            location: 'Delhi',
            description: 'Complete gym equipment set including dumbbells, bench, and resistance bands. Used for 6 months.',
            images: ['assets/images/placeholder.jpg'],
            sellerId: 'user2',
            sellerName: 'Jane Smith',
            isSold: false,
            datePosted: new Date(Date.now() - 1 * 24 * 60 * 60 * 1000).toISOString() // 1 day ago
        },
        {
            id: 'prod3',
            title: 'Designer Women\'s Handbag',
            price: 8000,
            category: 'others',
            condition: 'new',
            location: 'Bangalore',
            description: 'Genuine leather designer handbag. Never used. Comes with original packaging.',
            images: ['assets/images/placeholder.jpg'],
            sellerId: 'user1',
            sellerName: 'John Doe',
            isSold: false,
            datePosted: new Date(Date.now() - 3 * 24 * 60 * 60 * 1000).toISOString() // 3 days ago
        },
        {
            id: 'prod4',
            title: 'Running Shoes Nike',
            price: 5000,
            category: 'shoes',
            condition: 'new',
            location: 'Chennai',
            description: 'Size 9, Nike running shoes. Perfect condition. Never worn outside.',
            images: ['assets/images/placeholder.jpg'],
            sellerId: 'user2',
            sellerName: 'Jane Smith',
            isSold: false,
            datePosted: new Date(Date.now() - 5 * 24 * 60 * 60 * 1000).toISOString() // 5 days ago
        },
        {
            id: 'prod5',
            title: 'MacBook Pro 2020',
            price: 120000,
            category: 'electronics',
            condition: 'used',
            location: 'Hyderabad',
            description: '13-inch MacBook Pro, 16GB RAM, 512GB SSD. Well maintained, works perfectly.',
            images: ['assets/images/placeholder.jpg'],
            sellerId: 'user1',
            sellerName: 'John Doe',
            isSold: true,
            datePosted: new Date(Date.now() - 10 * 24 * 60 * 60 * 1000).toISOString() // 10 days ago
        },
        {
            id: 'prod6',
            title: 'Vintage Designer Saree',
            price: 12000,
            category: 'garments',
            condition: 'new',
            location: 'Kolkata',
            description: 'Hand-woven silk saree with zari work. Traditional Banarasi saree.',
            images: ['assets/images/placeholder.jpg'],
            sellerId: 'user3',
            sellerName: 'Bob Johnson',
            isSold: true,
            datePosted: new Date(Date.now() - 15 * 24 * 60 * 60 * 1000).toISOString() // 15 days ago
        }
    ];

    // Save sample data to localStorage
    localStorage.setItem('users', JSON.stringify(sampleUsers));
    localStorage.setItem('products', JSON.stringify(sampleProducts));

    console.log('Sample data initialized successfully!');
}

// Add sample data initialization to the main app
document.addEventListener('DOMContentLoaded', function() {
    initializeSampleData();
});